<?php
require_once 'config.php';
require_once 'otp_handler.php';
session_start();

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    
    if (empty($email)) {
        $error = 'Please enter your email address.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } else {
        // Check if email exists in users table
        $stmt = $conn->prepare('SELECT id FROM users WHERE email = ?');
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            $error = 'Email not found in our system.';
        } else {
            // Generate and send OTP
            $otpHandler = new OTPHandler($conn);
            $otp = $otpHandler->generateOTP();
            
            if ($otpHandler->sendOTPEmail($email, $otp, 'password_reset') && $otpHandler->storeOTP($email, $otp, 'password_reset')) {
                $_SESSION['reset_email'] = $email;
                $_SESSION['reset_step'] = 1; // Step 1: OTP verification
                $success = 'OTP has been sent to your email! Redirecting...';
                echo '<meta http-equiv="refresh" content="2; url=reset_password.php">';
            } else {
                $error = 'Failed to send OTP. Please try again.';
            }
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password - Cleaning Service</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .forgot-page-wrapper { min-height: calc(100vh - 400px); display: flex; align-items: center; justify-content: center; padding: 40px 20px; background: #f8f9fa; }
        .forgot-form-container { width: 100%; max-width: 450px; background: white; padding: 40px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1); }
        .forgot-form-header { text-align: center; margin-bottom: 30px; }
        .forgot-form-header h2 { font-size: 28px; color: #063A41; margin-bottom: 10px; }
        .forgot-form-header p { color: #5E5C78; font-size: 14px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; color: #063A41; font-weight: 500; }
        .form-group input { width: 100%; padding: 12px 14px; border: 1px solid #CDD5D6; border-radius: 8px; font-size: 14px; }
        .form-group input:focus { outline: none; border-color: #0984e3; box-shadow: 0 0 0 3px rgba(9, 132, 227, 0.1); }
        .form-submit-btn { width: 100%; padding: 14px; background: linear-gradient(85deg, #FF9800 0%, #FF6B35 72%); color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; margin-top: 10px; }
        .form-submit-btn:hover { opacity: 0.9; }
        .forgot-links { margin-top: 20px; text-align: center; font-size: 14px; }
        .forgot-links a { color: #0984e3; text-decoration: none; font-weight: 600; }
        .error { background-color: #fee; color: #c33; padding: 12px; border-radius: 8px; margin-bottom: 20px; border-left: 4px solid #c33; }
        .success { background-color: #efe; color: #093; padding: 12px; border-radius: 8px; margin-bottom: 20px; border-left: 4px solid #093; }
    </style>
</head>
<body>
    
    <?php include 'header.php'; ?>
    
    <div class="forgot-page-wrapper">
        <div class="forgot-form-container">
            <div class="forgot-form-header">
                <h2>Reset Your Password 🔐</h2>
                <p>Enter your email to receive an OTP code</p>
            </div>

            <?php if ($error): ?>
                <div class="error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="success"><?php echo htmlspecialchars($success); ?></div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" id="email" name="email" placeholder="Enter your registered email" required>
                    <small style="color: #666;">We'll send you an OTP code to verify your email</small>
                </div>

                <button type="submit" class="form-submit-btn">Send OTP</button>

                <div class="forgot-links">
                    <p><a href="login.php">Back to Login</a></p>
                </div>
            </form>
        </div>
    </div>

    <?php include 'footer.php'; ?>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
</body>
</html>
